<?php
	include dirname(__FILE__).'/fang.class.php';
	$fangobj=new fang();

	function formatzhongjieurl($id,$is_rewrite=1,$preview=0)
	{
		global $fangobj;

		return $fangobj->formatzhongjieurl($id,$is_rewrite,$preview);
	}
	
	function formatloupanurl($id,$is_rewrite=1,$preview=0)
	{
		global $fangobj;

		return $fangobj->formatloupanurl($id,$is_rewrite,$preview);
	}

	function getloupanname($id)
	{
		global $fangobj;
		$r=$fangobj->getloupan(intval($id));
		return $r?$r['title']:'δ֪¥';
	}

	function parse_fang_template($str)
	{
		$str=preg_replace('/\{niubi:loupan\s+([^\}]+)\}/ie',"la_call_user_func('get_loupan_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:loupan\}/i',"<?php }unset(\$_DATA); ?>",$str); 

		$str=preg_replace('/\{niubi:zhongjie\s+([^\}]+)\}/ie',"la_call_user_func('get_zhongjie_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:zhongjie\}/i',"<?php }unset(\$_DATA); ?>",$str);  

		return $str;
	}

	function get_loupan_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('limit'=>'0',
					'row'=>'16',
					'istop'=>'-1',
					'userid'=>'0',
					'istopic'=>'-1',
					'isfocus'=>'-1',
					'withthumb'=>'0');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_loupan_data('.$limit.','.$row.','.$istop.','.$userid.','.$istopic.','.$isfocus.','.$withthumb.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_loupan_data($limit,$row,$istop,$userid,$istopic,$isfocus,$withthumb)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$userid=intval($userid)?intval($userid):0;
		$istop=intval($istop)>-1?intval($istop):-1;
		$istopic=intval($istopic)>-1?intval($istopic):-1;
		$isfocus=intval($isfocus)>-1?intval($isfocus):-1;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).') AND status=1 AND ishidden=0';
		}
		else
		{
			$where='status=1 AND ishidden=0';
		}

		if($istop==-1)
		{
			$where.='';
		}
		else if($istop==0)
		{
			$where.=' AND (istop='.intval($istop).' OR istop<'.TIME.')';
		}
		else
		{
			$where.=' AND istop>='.TIME;
		}

		if($istopic==-1)
		{
			$where.='';
		}
		else if($istopic==0)
		{
			$where.=' AND (istopic='.intval($istopic).' OR istopic<'.TIME.')';
		}
		else
		{
			$where.=' AND istopic>='.TIME;
		}

		if($isfocus==-1)
		{
			$where.='';
		}
		else if($isfocus==0)
		{
			$where.=' AND (isfocus='.intval($isfocus).' OR isfocus<'.TIME.')';
		}
		else
		{
			$where.=' AND isfocus>='.TIME;
		}
		
		$where.=$userid?' AND userid='.intval($userid):'';

		$where.=$withthumb?' AND thumb!=\'\'':'';
		
		$sql="SELECT * FROM `".LA_PRE."loupan` WHERE $where ORDER BY `".LA_PRE."loupan`.`id` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_zhongjie_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('limit'=>'0',
					'row'=>'16',
					'istop'=>'-1',
					'withthumb'=>'0');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_zhongjie_data('.$limit.','.$row.','.$istop.','.$withthumb.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_zhongjie_data($limit,$row,$istop,$withthumb)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$istop=intval($istop)>-1?intval($istop):-1;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}

		if($istop==-1)
		{
			$where.='';
		}
		else if($istop==0)
		{
			$where.=' AND (istop='.intval($istop).' OR istop<'.TIME.')';
		}
		else
		{
			$where.=' AND istop>='.TIME;
		}

		$where.=$withthumb?' AND zhaopian!=\'\'':'';
		
		$sql="SELECT * FROM `".LA_PRE."loupan_zhongjie` WHERE $where ORDER BY `".LA_PRE."loupan_zhongjie`.`id` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}
?>